
dat=dat4



# NOTE: based on 1_data_processing, choose the corresponding estimation method #

########## OLS ##########

ols=ivreg(any_war~.,data=dat) # choose any_war, intra_state, or inter_state #
cluster.robust.se(ols,id)

ols=lm(any_war~.,data=dat) # choose any_war, intra_state, or inter_state #
summary(ols) # R-squared #

########## reduced form ##########

rf=ivreg(any_war~.,data=dat) # choose any_war, intra_state, or inter_state #
cluster.robust.se(rf,id) # the result here needs to be multiplied by 1000 #

rf=lm(any_war~.,data=dat) # choose any_war, intra_state, or inter_state #
summary(rf) # R-squared #

########## 2SLS ##########

tsls.2=ivreg(any_war~.-instrument2|.-wheat_aid+instrument2,data=dat,x=TRUE) # choose any_war, intra_state, or inter_state #
cluster.robust.se(tsls.2,id)
anderson.rubin.ci(tsls.2,conflevel=0.90)

########## first-stage ##########

tsls.1=ivreg(wheat_aid~.,data=dat)
cluster.robust.se(tsls.1,id)

dat$clusterid=id
fs=lm(wheat_aid~.-clusterid,data=dat)
fn=lm(wheat_aid~.-instrument2-clusterid,data=dat)
waldtest(fs,fn,vcov=clusterVCV(dat,fs,cluster1="clusterid"))$F[2]
